/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.util;

import com.mojang.math.Axis;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RawVoxelShape {
    private final Vector3f minP;
    private final Vector3f maxP;

    public RawVoxelShape(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minP = new Vector3f((float)minX, (float)minY, (float)minZ);
        this.maxP = new Vector3f((float)maxX, (float)maxY, (float)maxZ);
    }

    public RawVoxelShape rotateY(float degrees) {
        this.minP.add(-8.0f, -8.0f, -8.0f);
        this.maxP.add(-8.0f, -8.0f, -8.0f);
        this.minP.rotate((Quaternionfc)Axis.f_252436_.m_252977_(degrees));
        this.maxP.rotate((Quaternionfc)Axis.f_252436_.m_252977_(degrees));
        this.minP.add(8.0f, 8.0f, 8.0f);
        this.maxP.add(8.0f, 8.0f, 8.0f);
        return this;
    }

    public RawVoxelShape copy() {
        return new RawVoxelShape(this.minP.x(), this.minP.y(), this.minP.z(), this.maxP.x(), this.maxP.y(), this.maxP.z());
    }

    public VoxelShape toVoxelShape() {
        Vector3f newMinP = new Vector3f(Math.min(this.minP.x(), this.maxP.x()), Math.min(this.minP.y(), this.maxP.y()), Math.min(this.minP.z(), this.maxP.z()));
        Vector3f newMaxP = new Vector3f(Math.max(this.minP.x(), this.maxP.x()), Math.max(this.minP.y(), this.maxP.y()), Math.max(this.minP.z(), this.maxP.z()));
        return Block.m_49796_((double)newMinP.x(), (double)newMinP.y(), (double)newMinP.z(), (double)newMaxP.x(), (double)newMaxP.y(), (double)newMaxP.z());
    }
}

